/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.CreaturesYouControlCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.token.CatWarrior21Token;
import mage.game.permanent.token.Token;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;

class AjaniNacatlAvengerZeroEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("red permanent other than {this}");
    private static final Condition condition;

    AjaniNacatlAvengerZeroEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create a 2/1 white Cat Warrior creature token. When you do, if you control a red permanent other than {this}, he deals damage equal to the number of creatures you control to any target.";
    }

    private AjaniNacatlAvengerZeroEffect(AjaniNacatlAvengerZeroEffect effect) {
        super((OneShotEffect)effect);
    }

    public AjaniNacatlAvengerZeroEffect copy() {
        return new AjaniNacatlAvengerZeroEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (!new CreateTokenEffect((Token)new CatWarrior21Token()).apply(game, source)) {
            return false;
        }
        ReflexiveTriggeredAbility reflexive = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect((DynamicValue)CreaturesYouControlCount.PLURAL), false, "When you do, if you control a red permanent other than {this}, he deals damage equal to the number of creatures you control to any target.", condition);
        reflexive.addTarget((Target)new TargetAnyTarget());
        game.fireReflexiveTriggeredAbility(reflexive, source);
        return true;
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.RED));
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        condition = new PermanentsOnTheBattlefieldCondition(filter, true);
    }
}

