/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class AjaniSleeperAgentEffect
extends OneShotEffect {
    AjaniSleeperAgentEffect() {
        super(Outcome.Benefit);
        this.staticText = "Reveal the top card of your library. If it's a creature or planeswalker card, put it into your hand. Otherwise, you may put it on the bottom of your library.";
    }

    private AjaniSleeperAgentEffect(AjaniSleeperAgentEffect effect) {
        super((OneShotEffect)effect);
    }

    public AjaniSleeperAgentEffect copy() {
        return new AjaniSleeperAgentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        controller.revealCards(source, (Cards)new CardsImpl(card), game);
        if (card.isCreature(game) || card.isPlaneswalker(game)) {
            controller.moveCards(card, Zone.HAND, source, game);
        } else if (controller.chooseUse(Outcome.Neutral, "Put " + card.getName() + " on the bottom of your library?", source, game)) {
            controller.putCardsOnBottomOfLibrary(card, game, source);
        }
        return true;
    }
}

