/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.a.AkimTheSoaringWindCondition;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.BirdToken;
import mage.game.permanent.token.Token;

class AkimTheSoaringTokenAbility
extends TriggeredAbilityImpl {
    AkimTheSoaringTokenAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new BirdToken(), 1), false);
    }

    private AkimTheSoaringTokenAbility(AkimTheSoaringTokenAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CREATED_TOKEN;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!AkimTheSoaringWindCondition.instance.apply(game, (Ability)this)) {
            return false;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        return permanent != null && permanent.isControlledBy(this.getControllerId());
    }

    public AkimTheSoaringTokenAbility copy() {
        return new AkimTheSoaringTokenAbility(this);
    }

    public String getRule() {
        return "Whenever you create one or more tokens for the first time each turn, create a 1/1 white Bird creature token with flying.";
    }
}

