/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import mage.abilities.Abilities;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.keyword.DeathtouchAbility;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.HexproofBaseAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.MenaceAbility;
import mage.abilities.keyword.PartnerAbility;
import mage.abilities.keyword.ProtectionAbility;
import mage.abilities.keyword.ReachAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AkromaVisionOfIxidorEffect
extends OneShotEffect {
    private static final Set<Class<? extends Ability>> classes = new HashSet<Class>(Arrays.asList(FlyingAbility.class, FirstStrikeAbility.class, DoubleStrikeAbility.class, DeathtouchAbility.class, HasteAbility.class, HexproofBaseAbility.class, IndestructibleAbility.class, LifelinkAbility.class, MenaceAbility.class, ProtectionAbility.class, ReachAbility.class, TrampleAbility.class, VigilanceAbility.class, PartnerAbility.class));

    AkromaVisionOfIxidorEffect() {
        super(Outcome.Benefit);
        this.staticText = "until end of turn, each other creature you control gets +1/+1 if it has flying, +1/+1 if it has first strike, and so on for double strike, deathtouch, haste, hexproof, indestructible, lifelink, menace, protection, reach, trample, vigilance, and partner";
    }

    private AkromaVisionOfIxidorEffect(AkromaVisionOfIxidorEffect effect) {
        super((OneShotEffect)effect);
    }

    public AkromaVisionOfIxidorEffect copy() {
        return new AkromaVisionOfIxidorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_ANOTHER_CREATURE, source.getControllerId(), source, game)) {
            Abilities abilities = permanent.getAbilities(game);
            int count = classes.stream().map(clazz -> abilities.stream().anyMatch(clazz::isInstance)).mapToInt(b -> b != false ? 1 : 0).sum();
            if (count <= 0) continue;
            BoostTargetEffect effect = new BoostTargetEffect(count, count, Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent.getId(), game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

