/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.ControlACommanderCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.ProtectionAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.filter.Filter;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorlessPredicate;

public final class AkromasWill
extends CardImpl {
    private static final FilterCard filter = new FilterCard("all colors");

    public AkromasWill(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{3}{W}");
        this.getSpellAbility().getModes().setChooseText("Choose one. If you control a commander as you cast this spell, you may choose both instead.");
        this.getSpellAbility().getModes().setMoreCondition(2, (Condition)ControlACommanderCondition.instance);
        this.getSpellAbility().addEffect((Effect)new GainAbilityControlledEffect((Ability)FlyingAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE).setText("creatures you control gain flying"));
        this.getSpellAbility().addEffect((Effect)new GainAbilityControlledEffect((Ability)VigilanceAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE).setText(", vigilance"));
        this.getSpellAbility().addEffect((Effect)new GainAbilityControlledEffect((Ability)DoubleStrikeAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE).setText(", and double strike until end of turn"));
        Mode mode = new Mode((Effect)new GainAbilityControlledEffect((Ability)LifelinkAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE).setText("creatures you control gain lifelink"));
        mode.addEffect((Effect)new GainAbilityControlledEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE).setText(", indestructible"));
        mode.addEffect((Effect)new GainAbilityControlledEffect((Ability)new ProtectionAbility((Filter)filter), Duration.EndOfTurn, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE).setText(", and protection from each color until end of turn"));
        this.getSpellAbility().addMode(mode);
    }

    private AkromasWill(AkromasWill card) {
        super((CardImpl)card);
    }

    public AkromasWill copy() {
        return new AkromasWill(this);
    }

    static {
        filter.add(Predicates.not((Predicate)ColorlessPredicate.instance));
    }
}

