/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class AllHallowsEveEffect
extends OneShotEffect {
    AllHallowsEveEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "If there are no more scream counters on it, put it into your graveyard and each player returns all creature cards from their graveyard to the battlefield.";
    }

    private AllHallowsEveEffect(AllHallowsEveEffect effect) {
        super((OneShotEffect)effect);
    }

    public AllHallowsEveEffect copy() {
        return new AllHallowsEveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card allHallowsEveCard = (Card)source.getSourceObject(game);
        if (allHallowsEveCard == null) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        if (allHallowsEveCard.getCounters(game).getCount(CounterType.SCREAM) > 0) {
            return false;
        }
        controller.moveCards(allHallowsEveCard, Zone.GRAVEYARD, source, game);
        CardsImpl allCreatureCardsInGraveyards = new CardsImpl();
        game.getState().getPlayersInRange(source.getControllerId(), game).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).map(Player::getGraveyard).map(g -> g.getCards(game)).flatMap(Collection::stream).filter(card1 -> card1.isCreature(game)).forEach(arg_0 -> ((Cards)allCreatureCardsInGraveyards).add(arg_0));
        controller.moveCards(allCreatureCardsInGraveyards.getCards(game), Zone.BATTLEFIELD, source, game, false, false, true, null);
        return true;
    }
}

