/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.SoldierToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.ManaUtil;

class AllianceOfArmsEffect
extends OneShotEffect {
    AllianceOfArmsEffect() {
        super(Outcome.Detriment);
        this.staticText = "<i>Join forces</i> &mdash; Starting with you, each player may pay any amount of mana. Each player creates X 1/1 white Soldier creature tokens, where X is the total amount of mana paid this way";
    }

    private AllianceOfArmsEffect(AllianceOfArmsEffect effect) {
        super((OneShotEffect)effect);
    }

    public AllianceOfArmsEffect copy() {
        return new AllianceOfArmsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int xSum = 0;
            xSum += ManaUtil.playerPaysXGenericMana((boolean)false, (String)"Alliance of Arms", (Player)controller, (Ability)source, (Game)game);
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player;
                if (Objects.equals(playerId, controller.getId()) || (player = game.getPlayer(playerId)) == null) continue;
                xSum += ManaUtil.playerPaysXGenericMana((boolean)false, (String)"Alliance of Arms", (Player)player, (Ability)source, (Game)game);
            }
            if (xSum > 0) {
                for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                    CreateTokenTargetEffect effect = new CreateTokenTargetEffect((Token)new SoldierToken(), xSum);
                    effect.setTargetPointer((TargetPointer)new FixedTarget(playerId));
                    effect.apply(game, source);
                }
            }
            controller.resetStoredBookmark(game);
            return true;
        }
        return false;
    }
}

