/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.MageInt;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.common.CantBeCounteredSourceAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CantBeCounteredControlledEffect;
import mage.abilities.effects.common.continuous.CreaturesBecomeOtherTypeEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessAllEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.FilterSpell;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;

public class AllosaurusShepherd
extends CardImpl {
    private static final FilterSpell greenSpellsFilter = new FilterSpell("Green spells you control");
    private static final FilterPermanent elvesFilter = new FilterControlledCreaturePermanent("each Elf creature you control");

    public AllosaurusShepherd(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{G}");
        this.subtype.add((Object)SubType.ELF);
        this.subtype.add((Object)SubType.SHAMAN);
        this.power = new MageInt(1);
        this.toughness = new MageInt(1);
        this.addAbility((Ability)new CantBeCounteredSourceAbility());
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new CantBeCounteredControlledEffect(greenSpellsFilter, Duration.WhileOnBattlefield)));
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new SetBasePowerToughnessAllEffect(5, 5, Duration.EndOfTurn, elvesFilter).setText("Until end of turn, each Elf creature you control has base power and toughness 5/5"), (Cost)new ManaCostsImpl("{4}{G}{G}"));
        ability.addEffect((Effect)new CreaturesBecomeOtherTypeEffect(elvesFilter, SubType.DINOSAUR, Duration.EndOfTurn).setText("and becomes a Dinosaur in addition to its other creature types"));
        this.addAbility((Ability)ability);
    }

    private AllosaurusShepherd(AllosaurusShepherd card) {
        super((CardImpl)card);
    }

    public AllosaurusShepherd copy() {
        return new AllosaurusShepherd(this);
    }

    static {
        greenSpellsFilter.add((Predicate)new ColorPredicate(ObjectColor.GREEN));
        elvesFilter.add((Predicate)SubType.ELF.getPredicate());
    }
}

