/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.AnyColorManaAbility;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubTypeSet;
import mage.constants.SuperType;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class AlpineMoonEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent filter = new FilterLandPermanent();

    public AlpineMoonEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "lands your opponents control with the chosen name lose all land types and abilities, and they gain \"{T}: Add one mana of any color.\"";
        this.addDependedToType(DependencyType.BecomeMountain);
        this.addDependedToType(DependencyType.BecomeForest);
        this.addDependedToType(DependencyType.BecomeIsland);
        this.addDependedToType(DependencyType.BecomeSwamp);
        this.addDependedToType(DependencyType.BecomePlains);
        this.addDependedToType(DependencyType.BecomeNonbasicLand);
    }

    private AlpineMoonEffect(AlpineMoonEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public AlpineMoonEffect copy() {
        return new AlpineMoonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        if (cardName == null) {
            return false;
        }
        FilterPermanent filter2 = filter.copy();
        filter2.add((Predicate)new NamePredicate(cardName));
        for (Permanent land : game.getBattlefield().getActivePermanents(filter2, source.getControllerId(), game)) {
            switch (layer) {
                case TypeChangingEffects_4: {
                    land.removeAllSubTypes(game, SubTypeSet.NonBasicLandType);
                    break;
                }
                case AbilityAddingRemovingEffects_6: {
                    land.addAbility((Ability)new AnyColorManaAbility(), source.getSourceId(), game);
                }
            }
        }
        return true;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.AbilityAddingRemovingEffects_6 || layer == Layer.TypeChangingEffects_4;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
        filter.add(Predicates.not((Predicate)SuperType.BASIC.getPredicate()));
    }
}

