/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class AltairIbnLaAhadExileEffect
extends OneShotEffect {
    AltairIbnLaAhadExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to one target Assassin creature card from your graveyard with a memory counter on it";
    }

    private AltairIbnLaAhadExileEffect(AltairIbnLaAhadExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public AltairIbnLaAhadExileEffect copy() {
        return new AltairIbnLaAhadExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        card.addCounters(CounterType.MEMORY.createInstance(), source, game);
        return true;
    }
}

