/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.EnumSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class AminatousAuguryCastFromExileEffect
extends AsThoughEffectImpl {
    AminatousAuguryCastFromExileEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfTurn, Outcome.PlayForFree);
        this.staticText = "Cast this card without paying its mana cost";
    }

    private AminatousAuguryCastFromExileEffect(AminatousAuguryCastFromExileEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public AminatousAuguryCastFromExileEffect copy() {
        return new AminatousAuguryCastFromExileEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Player player = game.getPlayer(affectedControllerId);
        if (player == null) {
            return false;
        }
        if (!affectedControllerId.equals(source.getControllerId())) {
            return false;
        }
        EnumSet usedCardTypes = game.getState().getValue(source.getSourceId().toString() + "cardTypes") == null ? EnumSet.noneOf(CardType.class) : (EnumSet)game.getState().getValue(source.getSourceId().toString() + "cardTypes");
        if (objectId == null || !objectId.equals(this.getTargetPointer().getFirst(game, source))) {
            return false;
        }
        if (game.getState().getZone(objectId) != Zone.EXILED) {
            return false;
        }
        Card card = game.getCard(objectId);
        if (card == null) {
            return false;
        }
        EnumSet<CardType> unusedCardTypes = EnumSet.noneOf(CardType.class);
        for (CardType cardT : card.getCardType(game)) {
            if (usedCardTypes.contains(cardT)) continue;
            unusedCardTypes.add(cardT);
        }
        if (unusedCardTypes.isEmpty()) {
            return false;
        }
        if (!game.inCheckPlayableState()) {
            if (unusedCardTypes.size() > 1) {
                ChoiceImpl choice = new ChoiceImpl(true);
                choice.setMessage("Which card type do you want to consume?");
                Set choices = choice.getChoices();
                for (CardType cardType : unusedCardTypes) {
                    choices.add(cardType.toString());
                }
                player.choose(Outcome.Detriment, (Choice)choice, game);
                unusedCardTypes.removeIf(arg_0 -> AminatousAuguryCastFromExileEffect.lambda$applies$0((Choice)choice, arg_0));
                usedCardTypes.add(CardType.fromString((String)choice.getChoice()));
            }
            usedCardTypes.addAll(unusedCardTypes);
            game.getState().setValue(source.getSourceId().toString() + "cardTypes", (Object)usedCardTypes);
        }
        this.allowCardToPlayWithoutMana(objectId, source, player.getId(), game);
        return true;
    }

    private static /* synthetic */ boolean lambda$applies$0(Choice choice, CardType next) {
        return !next.toString().equals(choice.getChoice());
    }
}

