/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Optional;
import mage.MageObject;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.UntapTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.util.GameLog;

class AmuletOfVigorTriggeredAbility
extends TriggeredAbilityImpl {
    AmuletOfVigorTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new UntapTargetEffect());
    }

    private AmuletOfVigorTriggeredAbility(AmuletOfVigorTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public AmuletOfVigorTriggeredAbility copy() {
        return new AmuletOfVigorTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null && permanent.isTapped() && permanent.isControlledBy(this.getControllerId())) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer(new FixedTarget(event.getTargetId(), game).withData("triggeredName", GameLog.getColoredObjectIdNameForTooltip((MageObject)permanent)));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a permanent enters the battlefield tapped and under your control, untap it." + Optional.ofNullable(((Effect)this.getEffects().get(0)).getTargetPointer()).map(targetPointer -> targetPointer.getData("triggeredName")).filter(s -> s != null && !s.isEmpty()).map(s -> " Triggered permanent: " + s).orElse("");
    }
}

