/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AnaBattlemageEffect
extends OneShotEffect {
    AnaBattlemageEffect() {
        super(Outcome.Detriment);
        this.staticText = "and that creature deals damage equal to its power to its controller";
    }

    private AnaBattlemageEffect(AnaBattlemageEffect effect) {
        super((OneShotEffect)effect);
    }

    public AnaBattlemageEffect copy() {
        return new AnaBattlemageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (targetCreature == null) {
            return false;
        }
        Player controller = game.getPlayer(targetCreature.getControllerId());
        return controller != null && controller.damage(targetCreature.getPower().getValue(), source.getSourceId(), source, game) > 0;
    }
}

