/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.events.NumberOfTriggersEvent;
import mage.util.CardUtil;

class AncientGreenwardenEffect
extends ReplacementEffectImpl {
    AncientGreenwardenEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If a land entering causes a triggered ability of a permanent you control to trigger, that ability triggers an additional time";
    }

    private AncientGreenwardenEffect(AncientGreenwardenEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public AncientGreenwardenEffect copy() {
        return new AncientGreenwardenEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.NUMBER_OF_TRIGGERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!source.isControlledBy(event.getPlayerId())) {
            return false;
        }
        GameEvent sourceEvent = ((NumberOfTriggersEvent)event).getSourceEvent();
        if (sourceEvent == null || sourceEvent.getType() != GameEvent.EventType.ENTERS_THE_BATTLEFIELD || !(sourceEvent instanceof EntersTheBattlefieldEvent) || !((EntersTheBattlefieldEvent)sourceEvent).getTarget().isLand(game)) {
            return false;
        }
        return game.getPermanent(event.getSourceId()) != null;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowInc((int)event.getAmount(), (int)1));
        return false;
    }
}

