/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledArtifactPermanent;
import mage.game.Game;
import mage.players.Player;

class AncientRunesDamageTargetEffect
extends OneShotEffect {
    AncientRunesDamageTargetEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals damage to that player equal to the number of artifacts they control";
    }

    private AncientRunesDamageTargetEffect(AncientRunesDamageTargetEffect copy) {
        super((OneShotEffect)copy);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            int damage = game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterControlledArtifactPermanent("artifacts"), this.getTargetPointer().getFirst(game, source), game).size();
            player.damage(damage, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }

    public AncientRunesDamageTargetEffect copy() {
        return new AncientRunesDamageTargetEffect(this);
    }
}

