/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class AngelOfDestinyWatcher
extends Watcher {
    private final Map<MageObjectReference, Set<UUID>> map = new HashMap<MageObjectReference, Set<UUID>>();

    AngelOfDestinyWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ATTACKER_DECLARED) {
            return;
        }
        this.map.computeIfAbsent(new MageObjectReference(event.getSourceId(), game), u -> new HashSet()).add(event.getTargetId());
    }

    public void reset() {
        super.reset();
        this.map.clear();
    }

    Set<UUID> getPlayers(MageObjectReference mor) {
        return this.map.getOrDefault(mor, null);
    }
}

