/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class AngelOfGraceReplacementEffect
extends ReplacementEffectImpl {
    AngelOfGraceReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "until end of turn, damage that would reduce your life total to less than 1 reduces it to 1 instead";
    }

    private AngelOfGraceReplacementEffect(AngelOfGraceReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public AngelOfGraceReplacementEffect copy() {
        return new AngelOfGraceReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_CAUSES_LIFE_LOSS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller;
        if (event.getPlayerId().equals(source.getControllerId()) && (controller = game.getPlayer(source.getControllerId())) != null && controller.getLife() - event.getAmount() < 1) {
            event.setAmount(controller.getLife() - 1);
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return false;
    }
}

