/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AngelicGuardianGainEffect
extends OneShotEffect {
    AngelicGuardianGainEffect() {
        super(Outcome.Benefit);
        this.staticText = "they gain indestructible until end of turn";
    }

    private AngelicGuardianGainEffect(AngelicGuardianGainEffect effect) {
        super((OneShotEffect)effect);
    }

    public AngelicGuardianGainEffect copy() {
        return new AngelicGuardianGainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player you = game.getPlayer(source.getControllerId());
        if (you != null) {
            game.getCombat().getAttackers().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).filter(permanent -> permanent.isControlledBy(you.getId())).filter(permanent1 -> permanent1.isCreature(game)).forEach(permanent -> {
                GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                game.addEffect((ContinuousEffect)effect, source);
            });
            return true;
        }
        return false;
    }
}

