/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.continuous.GainProtectionFromColorTargetEffect;
import mage.abilities.keyword.ProtectionAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.Filter;
import mage.filter.FilterObject;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorlessPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AngelicInterventionEffect
extends OneShotEffect {
    private static final FilterObject filter = new FilterObject("colorless");

    AngelicInterventionEffect() {
        super(Outcome.Benefit);
        this.staticText = "target creature or planeswalker you control gains protection from colorless or from the color of your choice until end of turn. If it's a creature, put a +1/+1 counter on it";
    }

    private AngelicInterventionEffect(AngelicInterventionEffect effect) {
        super((OneShotEffect)effect);
    }

    public AngelicInterventionEffect copy() {
        return new AngelicInterventionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null || player == null) {
            return false;
        }
        if (player.chooseUse(this.outcome, "Give the targeted permanent protection from colorless?", null, "Yes", "No (choose a color instead)", source, game)) {
            game.addEffect((ContinuousEffect)new GainAbilityTargetEffect((Ability)new ProtectionAbility((Filter)filter), Duration.EndOfTurn), source);
        } else {
            game.addEffect((ContinuousEffect)new GainProtectionFromColorTargetEffect(Duration.EndOfTurn), source);
        }
        if (permanent.isCreature(game)) {
            permanent.addCounters(CounterType.P1P1.createInstance(), source, game);
        }
        return true;
    }

    static {
        filter.add((Predicate)ColorlessPredicate.instance);
    }
}

