/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.cards.a.AngrathTheFlameChainedDelayedTriggeredAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AngrathTheFlameCreateDelayedTriggerEffect
extends OneShotEffect {
    AngrathTheFlameCreateDelayedTriggerEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Sacrifice it at the beginning of the next end step if it has mana value 3 or less";
    }

    private AngrathTheFlameCreateDelayedTriggerEffect(AngrathTheFlameCreateDelayedTriggerEffect effect) {
        super((OneShotEffect)effect);
    }

    public AngrathTheFlameCreateDelayedTriggerEffect copy() {
        return new AngrathTheFlameCreateDelayedTriggerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            SacrificeTargetEffect sacrificeEffect = new SacrificeTargetEffect("sacrifice this", source.getControllerId());
            sacrificeEffect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            AngrathTheFlameChainedDelayedTriggeredAbility delayedAbility = new AngrathTheFlameChainedDelayedTriggeredAbility((Effect)sacrificeEffect);
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
            return true;
        }
        return false;
    }
}

