/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.CasualtyAbility;
import mage.cards.Card;
import mage.cards.a.AnheloThePainterWatcher;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;

class AnheloThePainterGainCausalityEffect
extends ContinuousEffectImpl {
    AnheloThePainterGainCausalityEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "The first instant or sorcery spell you cast each turn has casualty 2. <i>(As you cast that spell, you may sacrifice a creature with power 2 or greater. When you do, copy the spell and you may choose new targets for the copy.)</i>";
    }

    private AnheloThePainterGainCausalityEffect(AnheloThePainterGainCausalityEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        AnheloThePainterWatcher watcher = (AnheloThePainterWatcher)game.getState().getWatcher(AnheloThePainterWatcher.class);
        if (controller == null || watcher == null) {
            return false;
        }
        boolean applied = false;
        for (StackObject stackObject : game.getStack()) {
            if (!(stackObject instanceof Spell) || stackObject.isCopy() || !stackObject.isControlledBy(source.getControllerId()) || !AnheloThePainterWatcher.checkSpell(stackObject, game)) continue;
            Spell spell = (Spell)stackObject;
            Card card = spell.getCard();
            game.getState().addOtherAbility(card, (Ability)new CasualtyAbility(2));
            applied = true;
        }
        return applied;
    }

    public AnheloThePainterGainCausalityEffect copy() {
        return new AnheloThePainterGainCausalityEffect(this);
    }
}

