/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AnimalBoneyardEffect
extends OneShotEffect {
    AnimalBoneyardEffect() {
        super(Outcome.GainLife);
        this.staticText = "You gain life equal to the sacrificed creature's toughness";
    }

    private AnimalBoneyardEffect(AnimalBoneyardEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int toughness = 0;
            for (Cost cost : source.getCosts()) {
                if (!(cost instanceof SacrificeTargetCost) || ((SacrificeTargetCost)cost).getPermanents().isEmpty()) continue;
                toughness = ((Permanent)((SacrificeTargetCost)cost).getPermanents().get(0)).getToughness().getValue();
                break;
            }
            if (toughness > 0) {
                controller.gainLife(toughness, game, source);
            }
            return true;
        }
        return false;
    }

    public AnimalBoneyardEffect copy() {
        return new AnimalBoneyardEffect(this);
    }
}

