/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class AnimarCostReductionEffect
extends CostModificationEffectImpl {
    AnimarCostReductionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "Creature spells you cast cost {1} less to cast for each +1/+1 counter on Animar";
    }

    private AnimarCostReductionEffect(AnimarCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        Ability spellAbility = abilityToModify;
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent != null && spellAbility != null) {
            int amount = sourcePermanent.getCounters(game).getCount(CounterType.P1P1);
            CardUtil.reduceCost((Ability)spellAbility, (int)amount);
            return true;
        }
        return false;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        Card spellCard;
        if (abilityToModify instanceof SpellAbility && abilityToModify.isControlledBy(source.getControllerId()) && (spellCard = ((SpellAbility)abilityToModify).getCharacteristics(game)) != null) {
            return spellCard.isCreature(game);
        }
        return false;
    }

    public AnimarCostReductionEffect copy() {
        return new AnimarCostReductionEffect(this);
    }
}

