/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.BloodToken;
import mage.game.permanent.token.Token;

class AnjeMaidOfDishonorTriggeredAbility
extends TriggeredAbilityImpl {
    public AnjeMaidOfDishonorTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new BloodToken()));
        this.setTriggersLimitEachTurn(1);
        this.setTriggerPhrase("Whenever {this} and/or one or more other Vampires enter the battlefield under your control, ");
    }

    private AnjeMaidOfDishonorTriggeredAbility(AnjeMaidOfDishonorTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public AnjeMaidOfDishonorTriggeredAbility copy() {
        return new AnjeMaidOfDishonorTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null && permanent.isControlledBy(this.controllerId)) {
            return permanent.getId().equals(this.sourceId) || permanent.hasSubtype(SubType.VAMPIRE, game);
        }
        return false;
    }
}

