/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class AnnieJoinsUpEffect
extends ReplacementEffectImpl {
    AnnieJoinsUpEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if a triggered ability of a legendary creature you control triggers, that ability triggers an additional time";
    }

    private AnnieJoinsUpEffect(AnnieJoinsUpEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public AnnieJoinsUpEffect copy() {
        return new AnnieJoinsUpEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.NUMBER_OF_TRIGGERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        return permanent != null && permanent.isControlledBy(source.getControllerId()) && permanent.isLegendary(game) && permanent.isCreature(game);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowInc((int)event.getAmount(), (int)1));
        return false;
    }
}

