/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Objects;
import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.AbilityWord;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AnointWithAfflictionEffect
extends OneShotEffect {
    AnointWithAfflictionEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target creature if it has mana value 3 or less.<br>" + AbilityWord.CORRUPTED.formatWord() + "Exile that creature instead if its controller has three or more poison counters";
    }

    private AnointWithAfflictionEffect(AnointWithAfflictionEffect effect) {
        super((OneShotEffect)effect);
    }

    public AnointWithAfflictionEffect copy() {
        return new AnointWithAfflictionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        return player != null && permanent != null && (permanent.getManaValue() <= 3 || Optional.ofNullable(game.getPlayer(permanent.getControllerId())).filter(Objects::nonNull).map(p -> p.getCountersCount(CounterType.POISON) >= 3).orElse(false) != false) && player.moveCards((Card)permanent, Zone.EXILED, source, game);
    }
}

