/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureSourceEffect;
import mage.cards.a.AnsweredPrayersToken;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;

class AnsweredPrayersEffect
extends OneShotEffect {
    AnsweredPrayersEffect() {
        super(Outcome.Benefit);
        this.staticText = "you gain 1 life. If {this} isn't a creature, it becomes a 3/3 Angel creature with flying in addition to its other types until end of turn.";
    }

    private AnsweredPrayersEffect(AnsweredPrayersEffect effect) {
        super((OneShotEffect)effect);
    }

    public AnsweredPrayersEffect copy() {
        return new AnsweredPrayersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        new GainLifeEffect(1).apply(game, source);
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        if (permanent.isCreature(game)) {
            return true;
        }
        game.addEffect((ContinuousEffect)new BecomesCreatureSourceEffect((Token)new AnsweredPrayersToken(), CardType.ENCHANTMENT, Duration.EndOfTurn), source);
        return true;
    }
}

