/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.condition.common.HellbentCondition;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class AnthemOfRakdosHellbentEffect
extends ReplacementEffectImpl {
    AnthemOfRakdosHellbentEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "<i>Hellbent</i> &mdash; As long as you have no cards in hand, if a source you control would deal damage to a permanent or player, it deals double that damage to that permanent or player instead.";
    }

    private AnthemOfRakdosHellbentEffect(AnthemOfRakdosHellbentEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public AnthemOfRakdosHellbentEffect copy() {
        return new AnthemOfRakdosHellbentEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT || event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return game.getControllerId(event.getSourceId()).equals(source.getControllerId()) && HellbentCondition.instance.apply(game, source);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }
}

