/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.game.Game;
import mage.players.Player;

enum AnyaMercilessAngelDynamicValue implements DynamicValue
{
    instance;


    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        int opponentCount = 0;
        Player controller = game.getPlayer(sourceAbility.getControllerId());
        if (controller == null) {
            return 3 * opponentCount;
        }
        int startingLifeTotal = game.getStartingLife();
        for (UUID opponentId : game.getOpponents(controller.getId())) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || !opponent.isInGame() || opponent.getLife() >= startingLifeTotal / 2) continue;
            ++opponentCount;
        }
        return 3 * opponentCount;
    }

    public AnyaMercilessAngelDynamicValue copy() {
        return instance;
    }

    public String getMessage() {
        return "number of opponents whose life total is less than half their starting life total";
    }

    public String toString() {
        return "X";
    }
}

