/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ApathyEffect
extends OneShotEffect {
    ApathyEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player may discard a card at random. If the player does, untap that creature";
    }

    private ApathyEffect(ApathyEffect effect) {
        super((OneShotEffect)effect);
    }

    public ApathyEffect copy() {
        return new ApathyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        if (player == null) {
            return false;
        }
        if (!player.chooseUse(this.outcome, "Discard a card at random to untap enchanted creature?", source, game) || player.discardOne(true, false, source, game) == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        return (permanent = game.getPermanent(permanent.getAttachedTo())) != null && permanent.untap(game);
    }
}

