/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AquamorphEntityReplacementEffect
extends ReplacementEffectImpl {
    private static final String choice51 = "a 5/1 creature";
    private static final String choice15 = "a 1/5 creature";

    AquamorphEntityReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "as {this} enters or is turned face up, it becomes your choice of 5/1 or 1/5";
    }

    private AquamorphEntityReplacementEffect(AquamorphEntityReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case ENTERS_THE_BATTLEFIELD: 
            case TURN_FACE_UP: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent sourcePermanent;
        if (event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD && event.getTargetId().equals(source.getSourceId()) && (sourcePermanent = ((EntersTheBattlefieldEvent)event).getTarget()) != null && !sourcePermanent.isFaceDown(game)) {
            return true;
        }
        if (event.getType() == GameEvent.EventType.TURN_FACE_UP) {
            return event.getTargetId().equals(source.getSourceId());
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent = event instanceof EntersTheBattlefieldEvent ? ((EntersTheBattlefieldEvent)event).getTarget() : game.getPermanent(event.getTargetId());
        if (permanent == null) {
            return false;
        }
        ChoiceImpl choice = new ChoiceImpl(true);
        choice.setMessage("Choose what the creature becomes to");
        choice.getChoices().add(choice51);
        choice.getChoices().add(choice15);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && !controller.choose(Outcome.Neutral, (Choice)choice, game)) {
            this.discard();
            return false;
        }
        int power = 0;
        int toughness = 0;
        switch (choice.getChoice()) {
            case "a 5/1 creature": {
                power = 5;
                toughness = 1;
                break;
            }
            case "a 1/5 creature": {
                power = 1;
                toughness = 5;
            }
        }
        game.addEffect((ContinuousEffect)new SetBasePowerToughnessSourceEffect(power, toughness, Duration.WhileOnBattlefield), source);
        return false;
    }

    public AquamorphEntityReplacementEffect copy() {
        return new AquamorphEntityReplacementEffect(this);
    }
}

