/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetCardInYourGraveyard;

class ArachnusSpinnerEffect
extends OneShotEffect {
    ArachnusSpinnerEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Search your graveyard and/or library for a card named Arachnus Web and put it onto the battlefield attached to target creature. If you search your library this way, shuffle";
    }

    private ArachnusSpinnerEffect(ArachnusSpinnerEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArachnusSpinnerEffect copy() {
        return new ArachnusSpinnerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        TargetCardInYourGraveyard target;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        FilterCard filter = new FilterCard("card named Arachnus Web");
        filter.add((Predicate)new NamePredicate("Arachnus Web"));
        Card card = null;
        if (controller.chooseUse(Outcome.Neutral, "Search your graveyard for Arachnus Web?", source, game)) {
            target = new TargetCardInYourGraveyard(filter);
            if (controller.choose(Outcome.PutCardInPlay, (Cards)controller.getGraveyard(), (TargetCard)target, source, game)) {
                card = game.getCard(target.getFirstTarget());
            }
        }
        if (card == null) {
            target = new TargetCardInLibrary(filter);
            if (controller.searchLibrary((TargetCardInLibrary)target, source, game)) {
                card = game.getCard(target.getFirstTarget());
            }
            controller.shuffleLibrary(source, game);
        }
        if (card != null && (permanent = game.getPermanent(source.getFirstTarget())) != null) {
            game.getState().setValue("attachTo:" + card.getId(), (Object)permanent.getId());
            if (controller.moveCards(card, Zone.BATTLEFIELD, source, game)) {
                permanent.addAttachment(card.getId(), source, game);
            }
        }
        return true;
    }
}

