/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.GameState;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class AraumiOfTheDeadTideCost
extends CostImpl {
    AraumiOfTheDeadTideCost() {
        this.text = "exile cards from your graveyard equal to the number of opponents you have";
    }

    private AraumiOfTheDeadTideCost(AraumiOfTheDeadTideCost cost) {
        super((CostImpl)cost);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player player = game.getPlayer(controllerId);
        if (player == null) {
            return this.paid;
        }
        int oppCount = game.getOpponents(controllerId).size();
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(oppCount, StaticFilters.FILTER_CARD);
        target.withNotTarget(true);
        player.choose(Outcome.Exile, (Target)target, source, game);
        CardsImpl cards = new CardsImpl((Collection)target.getTargets());
        if (cards.size() < oppCount) {
            return this.paid;
        }
        player.moveCards((Cards)cards, Zone.EXILED, ability, game);
        this.paid = cards.stream().map(arg_0 -> ((GameState)game.getState()).getZone(arg_0)).filter(arg_0 -> Zone.EXILED.equals(arg_0)).count() >= (long)oppCount;
        return this.paid;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Player player = game.getPlayer(controllerId);
        return player != null && player.getGraveyard().size() >= game.getOpponents(controllerId).size();
    }

    public AraumiOfTheDeadTideCost copy() {
        return new AraumiOfTheDeadTideCost(this);
    }
}

