/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.io.ObjectStreamException;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class ArcTrailEffect
extends OneShotEffect {
    private static final ArcTrailEffect instance = new ArcTrailEffect();

    private Object readResolve() throws ObjectStreamException {
        return instance;
    }

    public static ArcTrailEffect getInstance() {
        return instance;
    }

    private ArcTrailEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 2 damage to any target and 1 damage to another target";
    }

    public boolean apply(Game game, Ability source) {
        boolean applied = false;
        boolean twoDamageDone = false;
        int damage = 2;
        for (Target target : source.getTargets()) {
            Player player;
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (twoDamageDone) {
                damage = 1;
            }
            if (permanent != null) {
                applied |= permanent.damage(damage, source.getSourceId(), source, game, false, true) > 0;
            }
            if ((player = game.getPlayer(target.getFirstTarget())) != null) {
                applied |= player.damage(damage, source.getSourceId(), source, game) > 0;
            }
            twoDamageDone = true;
        }
        return applied;
    }

    public ArcTrailEffect copy() {
        return instance;
    }
}

