/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class ArcaneBombardmentWatcher
extends Watcher {
    private final Map<UUID, Integer> playerMap = new HashMap<UUID, Integer>();

    ArcaneBombardmentWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        Spell spell = game.getSpell(event.getTargetId());
        if (spell != null && spell.isInstantOrSorcery(game)) {
            this.playerMap.compute(spell.getControllerId(), CardUtil::setOrIncrementValue);
        }
    }

    public void reset() {
        super.reset();
        this.playerMap.clear();
    }

    static boolean checkSpell(StackObject input, Game game) {
        return ((ArcaneBombardmentWatcher)game.getState().getWatcher(ArcaneBombardmentWatcher.class)).playerMap.getOrDefault(input.getControllerId(), 0) < 2;
    }
}

