/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.MageObjectReference;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.a.ArcbondEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.DamagedPermanentEvent;
import mage.game.events.GameEvent;

class ArcbondDelayedTriggeredAbility
extends DelayedTriggeredAbility
implements BatchTriggeredAbility<DamagedPermanentEvent> {
    MageObjectReference targetObject;

    ArcbondDelayedTriggeredAbility() {
        super((Effect)new ArcbondEffect(), Duration.EndOfTurn, false);
    }

    private ArcbondDelayedTriggeredAbility(ArcbondDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.targetObject = ability.targetObject;
    }

    public void init(Game game) {
        this.targetObject = new MageObjectReference(this.getTargets().getFirstTarget(), game);
        if (this.targetObject != null) {
            for (Effect effect : this.getEffects()) {
                effect.setValue("sourceId", (Object)this.targetObject.getSourceId());
            }
            this.getTargets().clear();
        }
    }

    public boolean isInactive(Game game) {
        if (this.targetObject == null) {
            return true;
        }
        return super.isInactive(game);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getTargetId().equals(this.targetObject.getSourceId()) && this.targetObject.getPermanentOrLKIBattlefield(game) != null) {
            this.getEffects().setValue("damage", (Object)event.getAmount());
            return true;
        }
        return false;
    }

    public ArcbondDelayedTriggeredAbility copy() {
        return new ArcbondDelayedTriggeredAbility(this);
    }

    public String getRule() {
        return "Choose target creature. Whenever that creature is dealt damage this turn, it deals that much damage to each other creature and each player.";
    }
}

