/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.common.SpellsCastWatcher;

class ArcboundTrackerTriggeredAbility
extends TriggeredAbilityImpl {
    public ArcboundTrackerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance()));
        this.setTriggerPhrase("Whenever you cast a spell other than your first spell each turn, ");
    }

    private ArcboundTrackerTriggeredAbility(ArcboundTrackerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ArcboundTrackerTriggeredAbility copy() {
        return new ArcboundTrackerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getPlayerId().equals(this.getControllerId())) {
            SpellsCastWatcher watcher = (SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class);
            return watcher != null && watcher.getSpellsCastThisTurn(event.getPlayerId()).size() > 1;
        }
        return false;
    }
}

