/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.condition.common.SaddledCondition;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.FlashbackAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;

class ArchmagesNewtEffect
extends ContinuousEffectImpl {
    private boolean saddled = false;

    ArchmagesNewtEffect() {
        super(Duration.EndOfTurn, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "target instant or sorcery card in your graveyard gains flashback until end of turn. The flashback cost is equal to its mana cost. That card gains flashback {0} until end of turn instead if {this} is saddled";
    }

    private ArchmagesNewtEffect(ArchmagesNewtEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.saddled = effect.saddled;
    }

    public ArchmagesNewtEffect copy() {
        return new ArchmagesNewtEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.saddled = SaddledCondition.instance.apply(game, source);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card == null) {
            return false;
        }
        FlashbackAbility ability = this.saddled ? new FlashbackAbility(card, (Cost)new GenericManaCost(0)) : new FlashbackAbility(card, (Cost)card.getManaCost());
        ability.setSourceId(card.getId());
        ability.setControllerId(card.getOwnerId());
        game.getState().addOtherAbility(card, (Ability)ability);
        return true;
    }
}

