/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class ArchonOfCoronationEffect
extends ReplacementEffectImpl {
    ArchonOfCoronationEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "As long as you're the monarch, damage doesn't cause you to lose life. <i>(When a creature deals combat damage to you, its controller still becomes the monarch.)</i>";
    }

    private ArchonOfCoronationEffect(ArchonOfCoronationEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public ArchonOfCoronationEffect copy() {
        return new ArchonOfCoronationEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_CAUSES_LIFE_LOSS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId()) && source.isControlledBy(game.getMonarchId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(0);
        return false;
    }
}

