/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class ArclightPhoenixWatcher
extends Watcher {
    private final Map<UUID, Integer> instantSorceryCount = new HashMap<UUID, Integer>();

    ArclightPhoenixWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell != null && spell.isInstantOrSorcery(game)) {
            this.instantSorceryCount.compute(spell.getControllerId(), CardUtil::setOrIncrementValue);
        }
    }

    public void reset() {
        super.reset();
        this.instantSorceryCount.clear();
    }

    static boolean getInstantSorceryCount(Game game, Ability source) {
        return ((ArclightPhoenixWatcher)game.getState().getWatcher(ArclightPhoenixWatcher.class)).instantSorceryCount.getOrDefault(source.getControllerId(), 0) >= 3;
    }
}

