/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class ArdennIntrepidArchaeologistEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent("Auras and Equipment you control");

    ArdennIntrepidArchaeologistEffect() {
        super(Outcome.Benefit);
        this.staticText = "attach any number of Auras and Equipment you control to target permanent or player";
    }

    private ArdennIntrepidArchaeologistEffect(ArdennIntrepidArchaeologistEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArdennIntrepidArchaeologistEffect copy() {
        return new ArdennIntrepidArchaeologistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(source.getFirstTarget());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (controller == null || player == null && permanent == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, filter, true);
        controller.choose(this.outcome, (Target)target, source, game);
        for (UUID targetId : target.getTargets()) {
            if (player != null) {
                player.addAttachment(targetId, source, game);
                continue;
            }
            if (permanent == null) continue;
            permanent.addAttachment(targetId, source, game);
        }
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)SubType.AURA.getPredicate(), (Predicate)SubType.EQUIPMENT.getPredicate()));
    }
}

