/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class ArdentDustspeakerCost
extends CostImpl {
    private static final FilterCard filter = new FilterInstantOrSorceryCard("instant or sorcery card from your graveyard");

    ArdentDustspeakerCost() {
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(filter);
        target.withNotTarget(true);
        this.addTarget((Target)target);
        this.text = "put an instant or sorcery card from your graveyard on the bottom of your library";
    }

    private ArdentDustspeakerCost(ArdentDustspeakerCost cost) {
        super((CostImpl)cost);
    }

    public ArdentDustspeakerCost copy() {
        return new ArdentDustspeakerCost(this);
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return this.canChooseOrAlreadyChosen(ability, source, controllerId, game);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Card card;
        Player controller = game.getPlayer(controllerId);
        if (controller != null && controller.chooseTarget(Outcome.Benefit, (Target)this.getTargets().get(0), source, game) && (card = game.getCard(((Target)this.getTargets().get(0)).getFirstTarget())) != null) {
            controller.putCardsOnBottomOfLibrary(card, game, source);
            this.paid = true;
        }
        return this.paid;
    }
}

