/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ManaSpentDelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AddContinuousEffectToGame;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.filter.FilterSpell;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ArenaOfGloryDelayedTriggeredAbility
extends ManaSpentDelayedTriggeredAbility {
    ArenaOfGloryDelayedTriggeredAbility() {
        super((Effect)new AddContinuousEffectToGame(new ContinuousEffect[]{new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn, "it gains haste until end of turn", true)}), (FilterSpell)StaticFilters.FILTER_SPELL_CREATURE);
        this.usesStack = false;
        this.triggerOnlyOnce = false;
        this.setTriggerPhrase("If that mana is spent on a creature spell, ");
    }

    private ArenaOfGloryDelayedTriggeredAbility(ArenaOfGloryDelayedTriggeredAbility effect) {
        super((ManaSpentDelayedTriggeredAbility)effect);
    }

    public ArenaOfGloryDelayedTriggeredAbility copy() {
        return new ArenaOfGloryDelayedTriggeredAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!super.checkTrigger(event, game)) {
            return false;
        }
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell == null) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(spell.getCard(), game));
        return true;
    }
}

