/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class ArgentumMasticoreEffect
extends OneShotEffect {
    ArgentumMasticoreEffect() {
        super(Outcome.Benefit);
        this.staticText = "sacrifice {this} unless you discard a card. When you discard a card this way, destroy target nonland permanent an opponent controls with mana value less than or equal to the mana value of the discarded card";
    }

    private ArgentumMasticoreEffect(ArgentumMasticoreEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArgentumMasticoreEffect copy() {
        return new ArgentumMasticoreEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (player.getHand().isEmpty() || !player.chooseUse(this.outcome, "Discard a card?", source, game)) {
            if (permanent != null) {
                permanent.sacrifice(source, game);
            }
            return true;
        }
        Card card = player.discardOne(false, false, source, game);
        if (card == null) {
            if (permanent != null) {
                permanent.sacrifice(source, game);
            }
            return true;
        }
        FilterNonlandPermanent filter = new FilterNonlandPermanent("nonland permanent an opponent controls with mana value " + card.getManaValue() + " or less");
        filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, card.getManaValue() + 1));
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DestroyTargetEffect(), false);
        ability.addTarget((Target)new TargetPermanent((FilterPermanent)filter));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

