/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class ArmedAndArmoredEquipEffect
extends OneShotEffect {
    ArmedAndArmoredEquipEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose a Dwarf you control. Attach any number of Equipment you control to it.";
    }

    private ArmedAndArmoredEquipEffect(ArmedAndArmoredEquipEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArmedAndArmoredEquipEffect copy() {
        return new ArmedAndArmoredEquipEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        FilterControlledPermanent dwarfFilter = new FilterControlledPermanent(SubType.DWARF);
        List dwarves = game.getBattlefield().getAllActivePermanents((FilterPermanent)dwarfFilter, controller.getId(), game);
        FilterControlledPermanent equipmentFilter = new FilterControlledPermanent(SubType.EQUIPMENT);
        List equipment = game.getBattlefield().getAllActivePermanents((FilterPermanent)equipmentFilter, controller.getId(), game);
        if (!dwarves.isEmpty() && !equipment.isEmpty()) {
            TargetPermanent target = new TargetPermanent(0, 1, (FilterPermanent)dwarfFilter, true);
            target.withChooseHint("dwarf to be equipped");
            controller.choose(this.outcome, (Target)target, source, game);
            Permanent dwarf = game.getPermanent(target.getFirstTarget());
            if (dwarf != null) {
                target = new TargetPermanent(0, Integer.MAX_VALUE, (FilterPermanent)equipmentFilter, true);
                target.withChooseHint("equip to " + dwarf.getLogName());
                controller.choose(this.outcome, (Target)target, source, game);
                for (UUID targetId : target.getTargets()) {
                    dwarf.addAttachment(targetId, source, game);
                    game.informPlayers(game.getPermanent(targetId).getLogName() + " was attached to " + dwarf.getLogName());
                }
            }
        }
        return true;
    }
}

