/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.Counters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;

class ArnaKennerudSkycaptainTargetEffect
extends OneShotEffect {
    ArnaKennerudSkycaptainTargetEffect() {
        super(Outcome.Benefit);
        this.staticText = "double the number of each kind of counter on it. Then for each nontoken permanent attached to it, create a token that's a copy of that permanent attached to that creature";
    }

    private ArnaKennerudSkycaptainTargetEffect(ArnaKennerudSkycaptainTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArnaKennerudSkycaptainTargetEffect copy() {
        return new ArnaKennerudSkycaptainTargetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        Counters counters = permanent.getCounters(game).copy();
        for (Counter counter : counters.values()) {
            permanent.addCounters(counter, source, game);
        }
        Set attachments = permanent.getAttachments().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).filter(p -> !(p instanceof PermanentToken)).collect(Collectors.toSet());
        for (Permanent attachment : attachments) {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect();
            effect.setSavedPermanent(attachment);
            effect.setAttachedTo(permanent.getId());
            effect.apply(game, source);
        }
        return true;
    }
}

