/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.cards.a.ArniMetalbrowEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class ArniMetalbrowTriggeredAbility
extends TriggeredAbilityImpl {
    ArniMetalbrowTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DoIfCostPaid((Effect)new ArniMetalbrowEffect(), (Cost)new ManaCostsImpl("{1}{R}")));
        this.setTriggerPhrase("Whenever a creature you control attacks or a creature you control enters attacking, ");
    }

    private ArniMetalbrowTriggeredAbility(ArniMetalbrowTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ArniMetalbrowTriggeredAbility copy() {
        return new ArniMetalbrowTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD || event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        switch (event.getType()) {
            case ENTERS_THE_BATTLEFIELD: {
                permanent = ((EntersTheBattlefieldEvent)event).getTarget();
                break;
            }
            case ATTACKER_DECLARED: {
                permanent = game.getPermanent(event.getSourceId());
                break;
            }
            default: {
                return false;
            }
        }
        if (!(permanent != null && permanent.isCreature(game) && permanent.isAttacking() && permanent.isControlledBy(this.getControllerId()))) {
            return false;
        }
        this.getEffects().setValue("attacker", (Object)permanent);
        return true;
    }
}

