/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheEndOfCombatDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ArthurMarigoldKnightEffect
extends OneShotEffect {
    ArthurMarigoldKnightEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "look at the top six cards of your library. You may put a creature card from among them onto the battlefield tapped and attacking. Put the rest on the bottom of your library in a random order. Return that creature to its owner's hand at end of combat.";
    }

    private ArthurMarigoldKnightEffect(ArthurMarigoldKnightEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 6));
        TargetCardInLibrary targetCardInLibrary = new TargetCardInLibrary(0, 1, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        player.choose(this.outcome, (Cards)cards, (TargetCard)targetCardInLibrary, source, game);
        Card card = game.getCard(targetCardInLibrary.getFirstTarget());
        if (card == null || !player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, true, null)) {
            return player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        }
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        }
        game.getCombat().addAttackingCreature(permanent.getId(), game);
        cards.remove(card);
        ReturnToHandTargetEffect returnToHandEffect = new ReturnToHandTargetEffect();
        returnToHandEffect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
        AtTheEndOfCombatDelayedTriggeredAbility delayedAbility = new AtTheEndOfCombatDelayedTriggeredAbility((Effect)returnToHandEffect);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
        return player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
    }

    public ArthurMarigoldKnightEffect copy() {
        return new ArthurMarigoldKnightEffect(this);
    }
}

