/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.cards.a.ArvinoxTheMindFlailCastFromExileEffect;
import mage.cards.a.ArvinoxTheMindFlailLookEffect;
import mage.cards.a.ArvinoxTheMindFlailSpendAnyManaEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ArvinoxTheMindFlailExileEffect
extends OneShotEffect {
    ArvinoxTheMindFlailExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the bottom card of each opponent's library face down. For as long as those cards remain exiled, you may look at them, you may cast permanent spells from among them, and you may spend mana as though it were mana of any color to cast those spells";
    }

    private ArvinoxTheMindFlailExileEffect(ArvinoxTheMindFlailExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArvinoxTheMindFlailExileEffect copy() {
        return new ArvinoxTheMindFlailExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(playerId);
            if (opponent == null) continue;
            cards.add(opponent.getLibrary().getFromBottom(game));
        }
        controller.moveCardsToExile(cards.getCards(game), source, game, false, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        cards.getCards(game).stream().forEach(card -> card.setFaceDown(true, game));
        for (Card card2 : cards.getCards(game)) {
            card2.setFaceDown(true, game);
            game.addEffect(new ArvinoxTheMindFlailCastFromExileEffect().setTargetPointer((TargetPointer)new FixedTarget(card2, game)), source);
            game.addEffect(new ArvinoxTheMindFlailSpendAnyManaEffect().setTargetPointer((TargetPointer)new FixedTarget(card2, game)), source);
            game.addEffect(new ArvinoxTheMindFlailLookEffect(source.getControllerId()).setTargetPointer((TargetPointer)new FixedTarget(card2, game)), source);
        }
        return true;
    }
}

