/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.a.AsForetoldAlternativeCost;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AsForetoldAddAltCostEffect
extends ContinuousEffectImpl {
    AsForetoldAddAltCostEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Once each turn, you may pay {0} rather than pay the mana cost for a spell you cast with mana value X or less, where X is the number of time counters on {this}.";
    }

    private AsForetoldAddAltCostEffect(AsForetoldAddAltCostEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public AsForetoldAddAltCostEffect copy() {
        return new AsForetoldAddAltCostEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent sourcePermanent;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (sourcePermanent = game.getPermanent(source.getSourceId())) != null) {
            Boolean wasItUsed = (Boolean)game.getState().getValue(sourcePermanent.getId().toString() + sourcePermanent.getZoneChangeCounter(game) + sourcePermanent.getTurnsOnBattlefield());
            if (wasItUsed == null) {
                int timeCounters = sourcePermanent.getCounters(game).getCount(CounterType.TIME);
                AsForetoldAlternativeCost alternateCostAbility = new AsForetoldAlternativeCost(timeCounters);
                alternateCostAbility.setSourceId(source.getSourceId());
                controller.getAlternativeSourceCosts().add(alternateCostAbility);
            }
            return true;
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.RulesEffects;
    }
}

